/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.planning;

import com.badlogic.gdx.ai.msg.PriorityQueue;
import com.badlogic.gdx.ai.pfa.DefaultGraphPath;
import com.badlogic.gdx.math.Vector2;
import java.util.Map;
import technology.rocketjump.undermount.entities.model.ai.pathfinding.Map2DCollection;
import technology.rocketjump.undermount.entities.model.ai.pathfinding.MapPathfindingNode;
import technology.rocketjump.undermount.entities.planning.PathfindingCallback;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.messaging.types.PathfindingRequestMessage;

public class PathfindingTask
implements Runnable {
    private final PathfindingCallback callback;
    private final MapTile originCell;
    private final MapTile destinationCell;
    private final Vector2 origin;
    private final Vector2 destination;
    private final TiledMap map;
    private final PriorityQueue<MapPathfindingNode> frontier = new PriorityQueue();
    private final Map2DCollection<MapPathfindingNode> explored;
    private final long relatedId;

    public PathfindingTask(PathfindingRequestMessage requestMessage) {
        this.callback = requestMessage.getCallback();
        this.map = requestMessage.getMap();
        this.explored = new Map2DCollection(this.map.getWidth());
        this.relatedId = requestMessage.getRelatedId();
        this.origin = requestMessage.getOrigin();
        this.originCell = this.map.getTile(this.origin);
        this.destination = requestMessage.getDestination();
        this.destinationCell = this.map.getTile(this.destination);
    }

    @Override
    public void run() {
        DefaultGraphPath<Vector2> path = new DefaultGraphPath<Vector2>();
        if (this.originCell.equals(this.destinationCell)) {
            path.add(this.destination);
            this.callback.pathfindingComplete(path, this.relatedId);
            return;
        }
        TileNeighbours navigableNeighbours = this.filterToNavigable(this.map.getNeighbours(this.originCell.getTileX(), this.originCell.getTileY()), this.originCell);
        for (MapTile neighbourCell : navigableNeighbours.values()) {
            Vector2 tileWorldPosition = neighbourCell.getWorldPositionOfCenter();
            MapPathfindingNode node = new MapPathfindingNode(tileWorldPosition, this.getDistance(this.origin, tileWorldPosition), null, this.getDistance(tileWorldPosition, this.destination));
            this.frontier.add(node);
            this.explored.add(neighbourCell.getTileX(), neighbourCell.getTileY(), node);
        }
        int maxNodesToExplore = this.calculateMaxNodesToExplore(this.map);
        for (int exploredNodes = 0; this.frontier.size() > 0 && exploredNodes < maxNodesToExplore; ++exploredNodes) {
            this.processNode(this.frontier.poll());
        }
        MapPathfindingNode nodeToNavigateVia = this.explored.get(this.destinationCell.getTileX(), this.destinationCell.getTileY());
        if (nodeToNavigateVia != null) {
            nodeToNavigateVia.setWorldPosition(this.destination);
        }
        while (nodeToNavigateVia != null) {
            path.add(nodeToNavigateVia.getWorldPosition());
            nodeToNavigateVia = nodeToNavigateVia.getPreviousNodeInPath();
        }
        path.reverse();
        this.callback.pathfindingComplete(path, this.relatedId);
    }

    private void processNode(MapPathfindingNode node) {
        MapTile nodeCell = this.map.getTile(node.getWorldPosition());
        if (nodeCell.equals(this.destinationCell)) {
            this.frontier.clear();
        } else {
            TileNeighbours neighbours = this.map.getNeighbours(nodeCell.getTileX(), nodeCell.getTileY());
            neighbours = this.filterToNavigable(neighbours, nodeCell);
            for (Map.Entry neighboursEntry : neighbours.entrySet()) {
                float newCostToGetHere = node.getCostToGetHere() + ((CompassDirection)((Object)neighboursEntry.getKey())).distance();
                MapTile neighbourCell = (MapTile)neighboursEntry.getValue();
                MapPathfindingNode previouslyExploredNode = this.explored.get(neighbourCell.getTileX(), neighbourCell.getTileY());
                if (previouslyExploredNode != null && !(previouslyExploredNode.getCostToGetHere() > newCostToGetHere)) continue;
                Vector2 positionOfNeighbourCell = neighbourCell.getWorldPositionOfCenter();
                MapPathfindingNode nextNode = new MapPathfindingNode(positionOfNeighbourCell, newCostToGetHere, node, this.getDistance(positionOfNeighbourCell, this.destination));
                this.explored.add(neighbourCell.getTileX(), neighbourCell.getTileY(), nextNode);
                this.frontier.add(nextNode);
            }
        }
    }

    private TileNeighbours filterToNavigable(TileNeighbours tileNeighbours, MapTile startingPoint) {
        TileNeighbours filtered = new TileNeighbours();
        block6: for (Map.Entry compassDirectionMapCellEntry : tileNeighbours.entrySet()) {
            CompassDirection direction = (CompassDirection)((Object)compassDirectionMapCellEntry.getKey());
            MapTile cellInDirection = (MapTile)compassDirectionMapCellEntry.getValue();
            if (!cellInDirection.isNavigable(startingPoint)) continue;
            if (direction.isDiagonal()) {
                switch (direction) {
                    case NORTH_EAST: {
                        if (!((MapTile)tileNeighbours.get((Object)CompassDirection.NORTH)).isNavigable() || !((MapTile)tileNeighbours.get((Object)CompassDirection.EAST)).isNavigable(startingPoint)) continue block6;
                        filtered.put(direction, cellInDirection);
                        continue block6;
                    }
                    case NORTH_WEST: {
                        if (!((MapTile)tileNeighbours.get((Object)CompassDirection.NORTH)).isNavigable() || !((MapTile)tileNeighbours.get((Object)CompassDirection.WEST)).isNavigable(startingPoint)) continue block6;
                        filtered.put(direction, cellInDirection);
                        continue block6;
                    }
                    case SOUTH_WEST: {
                        if (!((MapTile)tileNeighbours.get((Object)CompassDirection.SOUTH)).isNavigable() || !((MapTile)tileNeighbours.get((Object)CompassDirection.WEST)).isNavigable(startingPoint)) continue block6;
                        filtered.put(direction, cellInDirection);
                        continue block6;
                    }
                    case SOUTH_EAST: {
                        if (!((MapTile)tileNeighbours.get((Object)CompassDirection.SOUTH)).isNavigable() || !((MapTile)tileNeighbours.get((Object)CompassDirection.EAST)).isNavigable(startingPoint)) continue block6;
                        filtered.put(direction, cellInDirection);
                        continue block6;
                    }
                }
                throw new RuntimeException("Diagonal direction is incorrect, thought " + direction.name() + " is diagonal");
            }
            filtered.put(direction, cellInDirection);
        }
        return filtered;
    }

    private float getDistance(Vector2 a, Vector2 b) {
        return b.cpy().sub(a).len();
    }

    private int calculateMaxNodesToExplore(TiledMap map) {
        return Math.max(map.getWidth() / 2 * (map.getHeight() / 2), map.getWidth() * 2 + map.getHeight() * 2);
    }
}

